unit uMBScreenOverlay;

interface

uses Windows, Messages;

(*
General information:
- the calling convention of every function is STDCALL
- LONGINT is a 32bit signed integer value
- PCHAR is pointer to an 8 bit character string
- TPoint is equal to the windows POINT object
- TRect is equal to the windows RECT object

Every API call can also be handled by a script command
(in case, your language does not support one of the structs above)
The script command "MBScreenOverlay_ScriptCommand" only needs a PCHAR as
a parameter.
If the error code of MBScreenOverlay_ScriptCommand is lower than -99, the
parsing of the -[Errocode+99]th parameter returned an error

If a file named
<APPLICATIONNAME>.debug
exists in the application directory, debug output are written through the WIN API
"OutputDebugString" and stored in the file "MB-ScreenOverlay.log" when terminating the
application.
*)

const
  WM_OVERLAYELEMENT_CLICK = WM_USER + 7000;
  WM_OVERLAYELEMENT_DBLCLK = WM_USER + 7001;
  WM_OVERLAYELEMENT_MOUSEDOWN = WM_USER + 7002;
  WM_OVERLAYELEMENT_MOUSEMOVE = WM_USER + 7003;
  WM_OVERLAYELEMENT_MOUSEUP = WM_USER + 7004;
  WM_OVERLAYELEMENT_STATUSCHANGED = WM_USER + 7005;

const
  OVERLAYELEMENT_OPERATION_DELETE = 1;
  OVERLAYELEMENT_OPERATION_SHOW = 2;
  OVERLAYELEMENT_OPERATION_LINEWIDTH = 3;
  OVERLAYELEMENT_OPERATION_ISFILLED = 4;
  OVERLAYELEMENT_OPERATION_SETCOLOR = 5;
  OVERLAYELEMENT_OPERATION_SETAUTOHIDE = 6;
  OVERLAYELEMENT_OPERATION_SETZORDER = 7;
  OVERLAYELEMENT_OPERATION_SETMOUSECURSOR = 8;
  OVERLAYELEMENT_OPERATION_SETTRANSPARENT = 9;

const
  STATUSCHANGED_SET_VISIBLE_TRUE = $11;
  STATUSCHANGED_SET_VISIBLE_FALSE = $10;
  STATUSCHANGED_AUTOSHOW = $21;
  STATUSCHANGED_AUTOHIDE = $20;
  STATUSCHANGED_SET_AUTOHIDE_TRUE = $31;
  STATUSCHANGED_SET_AUTOHIDE_FALSE = $30;
  STATUSCHANGED_INSERT = $41;
  STATUSCHANGED_DELETE = $40;

const
  LibName = 'MB-ScreenOverlay.dll';

function MBScreenOverlay_Clear : Longint; stdcall; 
                                          external LibName;
(*
Clear all added screen transparent items.
You must call this function immediatelly after loading the library. If not, the information screen
will be shown 5 seconds after loading the library.
*)

function MBScreenOverlay_SetCallBackWindowHandle(Handle : HWND) : Longint; stdcall;
                                                                           external LibName;
(*
When moving the the mouse over the screen objects and clicking them, messages are send to the
calling application.
The mesages are send by the windows API PostMessage.

Handle is the window handle of the windows that will receive the messages.

The events are
  WM_OVERLAYELEMENT_CLICK = WM_USER + 7000;
  WM_OVERLAYELEMENT_DBLCLK = WM_USER + 7001;
  WM_OVERLAYELEMENT_MOUSEDOWN = WM_USER + 7002;
  WM_OVERLAYELEMENT_MOUSEMOVE = WM_USER + 7003;
  WM_OVERLAYELEMENT_MOUSEUP = WM_USER + 7004;

The WPARAM is the ID the the selected object (the ID of an object is the return value of the
creating functions).
LPARAMLOW is the x coordinate of mouse during the event.
LPARAMHIGH is the y coordiante of mouse during the event.

and
  WM_OVERLAYELEMENT_STATUSCHANGED = WM_USER + 7005;

The WPARAM is the ID the the selected object.
The LPARAM is one of the values
  STATUSCHANGED_SET_VISIBLE_TRUE = $11;    --> visible flag is changed to true
  STATUSCHANGED_SET_VISIBLE_FALSE = $10;   --> visible flag is changed to false
  STATUSCHANGED_AUTOSHOW = $21;            --> object is shown by "autohide"
  STATUSCHANGED_AUTOHIDE = $20;            --> obejct is hidden by "autohide"
  STATUSCHANGED_SET_AUTOHIDE_TRUE = $31;   --> autohide flag is changed to true
  STATUSCHANGED_SET_AUTOHIDE_FALSE = $30;  --> autohide flag is changed to false
  STATUSCHANGED_INSERT = $41;              --> object is inserted
  STATUSCHANGED_DELETE = $40;              --> object is deleted

*)

function MBScreenOverlay_Operation(Operation : Longint; ID : Longint; Value1 : integer; Value2 : Integer; Value3 : integer) : Longint; stdcall;
                                                                                                                                       external LibName;
(* 
Sets properties of created screen transparent objects
"Operation" is one of the above defined const "OVERLAYELEMENT_OPERATION_XXXX"
"ID" is the ID of the screen transparent item.
   (the ID of an object is the return value of the creating functions)

The meaning of "Value1", "Value2" and ""Value3" depend on "Operation". "Value2" and "Value3" are not in use at the moment.

Values for "Operation":
  OVERLAYELEMENT_OPERATION_DELETE
    Deletes the screen transparent object "ID"

  OVERLAYELEMENT_OPERATION_SHOW
    Shows (Value1 = 1) or Hides (Value1 = 0) of the screen transparent object "ID"

  OVERLAYELEMENT_OPERATION_LINEWIDTH
    Sets the line width of the screen transparent object "ID"
    "Value1" is the width of the line

  OVERLAYELEMENT_OPERATION_ISFILLED
    Defines, if the the screen transparent object "ID" filled (Value1 = 1) or not (Value1 = 0)

  OVERLAYELEMENT_OPERATION_SETCOLOR
    Sets the color of the screen transparent object "ID"
    "Value1" is the color of the object

  OVERLAYELEMENT_OPERATION_SETAUTOHIDE
    Sets the autohide property of the screen transparent object "ID"
    (Value1 = 1) : autohide on
    (Value1 = 2) : autohide off

  OVERLAYELEMENT_OPERATION_SETZORDER
    Sets the position of the screen transparent object "ID" - the lower the position, the earlier it is painted
    "Value1" is the Z-Order position of th object

  OVERLAYELEMENT_OPERATION_SETMOUSECURSOR
    Sets the mouse cursor of the screen transparent object "ID"
    "Value1" is the mouse cursor ID

  OVERLAYELEMENT_OPERATION_SETTRANSPARENT
    Sets the transparent mode of the screen transparent object "ID"
    "Value1" is the transparent factor:
        0 - no transparent
      100 - maximum transparent

If the function returns
1 the attribute is successfully set
0 the ID was not found
-1 an error occured when trying to set the mouse cursor

script command:
OPERATION <Operation> <ID> <Value1> <Value2> <Value3>
*)

function MBScreenOverlay_Point(Position : TPoint; Style : Longint; Color : COLORREF) : Longint; stdcall;
                                                                                                external LibName;
(*
Add a point object as screen transparent object.

"Position"  coordinate of the screen object in a POINT object.
"Style"     style of the object (1 = cross / 2 = circle / 3 = rectangle)
"Color"     color of the object

If the function returns
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
POINT <PositionX> <PositionY> <Style> <Color>
*)

function MBScreenOverlay_Line(StartPoint, EndPoint : TPoint; Color : COLORREF) : Longint; stdcall;
                                                                                          external LibName;
(*
Add a line object as a screen transparent object.

"StartPoint"  coordinate of the start point of the line in a POINT object
"EndPoint"    coordinate of the end point of the line in a POINT object
"Color"       color of the object

If the function returns
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
LINE <StartPointX> <StartPointY> <EndPointX> <EndPointY> <Color>
*)

function MBScreenOverlay_Polyline(Points : PPoint; NumPoint : Longint; Color : COLORREF) : Longint; stdcall;
                                                                                                    external LibName;
(*
Add a polyline object as a screen transparent object.

"Points"      pointer to the first point in an point array
"NumPoint"    number of points in the point array
"Color"       color of the object

If the function returns  
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
POLYLINE <NumPoint> <Point1X> <Point1Y> <Point2X> <Point2Y> [...] <PointNX> <PointNY>  <Color>
*)

function MBScreenOverlay_Rectangle(Rect : TRect; Color : COLORREF) : Longint; stdcall;
                                                                              external LibName;
(*
Add a rectangle object as a screen transparent object.

"Rect"    data of the rectangle in a RECT object
"Color"   color of the object

If the function returns  
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
RECTANGLE <Left> <Top> <Right> <Bottom> <Color>
*)

function MBScreenOverlay_Ellipse(Rect : TRect; Color : COLORREF) : Longint; stdcall;
                                                                            external LibName;
(*
Add an ellipse object as a screen transparent object.

"Rect"    data of the ellipse (left, top, right, bottom border) in a RECT object
"Color"   color of the object

If the function returns
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
ELLIPSE <Left> <Top> <Right> <Bottom> <Color>
*)

function MBScreenOverlay_Text(Position : TPoint; Text : pchar; FontName : pchar; Size : Longint; Bold, Italic : Longint; Color : COLORREF) : Longint; stdcall;
                                                                                                                                                      external LibName;
(*

add a text object as a screen transparent object

"Position"  coordinate of the screen object in a POINT object - the object is centered to
            these coordinates
"Text"      char pointer to the text, that will be displayed
"FontName"  char pointer to the font name (p.e. "Arial") of the font to be used
"Size"      size (in pixel) of the font
"Bold"      (=1 font is bold, =0 font is not bold)
"Italic"    (=1 font is italic, =0 font is not italic)
"Color"     color of the object

If the function returns
>0    the object was created - the return value is the ID of the object
<= 0  an error occured then trying to create the object

script command:
TEXT <PositionX> <PositionY> ''<Text>'' ''<FontName>'' <Size> <Bold> <Italic> <Color>
*)

function MBScreenOverlay_BitmapByFile(Position : TPoint; FileName : pchar; TransparentColor : COLORREF) : Longint; stdcall;
                                                                                                                   external LibName;
(*
add a bitmap object as a screen transparent object

"Position"             coordinate of the screen object in a POINT object
                       - the object is centered to  these coordinates
"FileName"             char pointer to the filename (BMP file)
"TransparentColor"     color in the bitmap, that will be display transparent

script command:
BITMAPBYFILE <PositionX> <PositionY> ''<FileName>'' <TransparentColor>
*)

function MBScreenOverlay_BitmapByResource(Position : TPoint; Instance: LongInt; ResourceName: pchar; TransparentColor : COLORREF) : Longint; stdcall;
                                                                                                                                                 external LibName;
(*
add a bitmap object as a screen transparent object

"Position"             coordinate of the screen object in a POINT object
                       - the object is centered to  these coordinates
"Instance"             Instance of the modul (EXE or DLL), where the bitmap is stored
"ResourceName"         char pointer to the name of the BITMAP resource
"TransparentColor"     color in the bitmap, that will be display transparent

script command:
BITMAPBYRESOURCE <PositionX> <PositionY> <Instane> ''<ResourceName>'' <TransparentColor>
*)

function MBScreenOverlay_ScriptCommand(ScriptLine : pchar) : Longint; StdCall;
                                                                      external LibName;
(*
execute the script line

This API is an alternativ way to access the MB-ScreenOverlay Command APIs
As some languages (like Visual Basic) have problems with structures, this API
handles every command only using a text string that will be parsed

"ScriptLine"           script line, that will be executed
                       have a look at the file "TestScriptCommandFile.txt" for examples and
                       descriptions of the different commands
*)

function MBScreenOverlay_ScriptCommandFile(ScriptCommandFile : pchar) : Longint; StdCall;
                                                                                 external LibName;
(*
parses and executes a script file will single script commands

"ScriptCommandFile"    name of the script file
*)

implementation


end.