unit uMBScreenOverlayDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMBScreenOverlay, CheckLst, ComCtrls;

type
  TMBScreenOverlayDemoForm = class(TForm)
    GroupePanel: TPanel;
    TestButtonPanel: TPanel;
    PointButton: TButton;
    RectButton: TButton;
    TextButton: TButton;
    ClearButton: TButton;
    MessageListBox: TListBox;
    ObjectsListBox: TCheckListBox;
    LineButton: TButton;
    PolylineButton: TButton;
    BitmapButton: TButton;
    GridCheckBox: TCheckBox;
    GridTrackBar: TTrackBar;
    EllipseButton: TButton;
    ScriptButton: TButton;
    SmoothTransparencyCheckBox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure PointButtonClick(Sender: TObject);
    procedure RectButtonClick(Sender: TObject);
    procedure EllipseButtonClick(Sender: TObject);    
    procedure TextButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure LineButtonClick(Sender: TObject);
    procedure PolylineButtonClick(Sender: TObject);
    procedure BitmapButtonClick(Sender: TObject);
    procedure ObjectsListBoxClickCheck(Sender: TObject);
    procedure ObjectsListBoxDblClick(Sender: TObject);
    procedure GridCheckBoxClick(Sender: TObject);
    procedure GridTrackBarChange(Sender: TObject);
    procedure ScriptButtonClick(Sender: TObject);
  private
    { Private-Deklarationen }
    GridStart, GridEnd : integer;
    function NumDemoElements : integer;
  public
    { Public-Deklarationen }

    procedure OverlayElementClick(var message : TMessage); message WM_OVERLAYELEMENT_CLICK;
    procedure OverlayElementDblClk(var message : TMessage); message WM_OVERLAYELEMENT_DBLCLK;
    procedure OverlayElementMouseDown(var message : TMessage); message WM_OVERLAYELEMENT_MOUSEDOWN;
    procedure OverlayElementMouseMove(var message : TMessage); message WM_OVERLAYELEMENT_MOUSEMOVE;
    procedure OverlayElementMouseUp(var message : TMessage); message WM_OVERLAYELEMENT_MOUSEUP;

    procedure OverlayElementStatusChange(var message : TMessage); message WM_OVERLAYELEMENT_STATUSCHANGED;
  end;

var
  MBScreenOverlayDemoForm: TMBScreenOverlayDemoForm;

implementation

{$R *.DFM}

function TMBScreenOverlayDemoForm.NumDemoElements : integer;
begin
  if (SmoothTransparencyCheckBox.Checked)
  then result := 1
  else result := 10;
end;

procedure TMBScreenOverlayDemoForm.FormCreate(Sender: TObject);
begin
  ScriptButton.Visible := FileExists('TestScriptCommandFile.txt');
  MBScreenOverlay_Clear;
  MBScreenOverlay_SetCallBackWindowHandle(Handle);
end;

procedure TMBScreenOverlayDemoForm.PointButtonClick(Sender: TObject);
var
  i1 : integer;
  ret : integer;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    ret := MBScreenOverlay_Point(Point(Random(Screen.Width),Random(Screen.Height)),   // Position
                                     Random(3),                                           // Style
                                     RGB(Random(255),Random(255),Random(255)));           // Color
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.RectButtonClick(Sender: TObject);
var
  i1 : integer;
  ret : integer;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    ret := MBScreenOverlay_Rectangle(Rect(Random(Screen.Width),Random(Screen.Height),   // Position
                                              Random(Screen.Width),Random(Screen.Height)),
                                         RGB(Random(255),Random(255),Random(255)));           // Color
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_LINEWIDTH, ret ,Random(3)+1, 0, 0);
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.EllipseButtonClick(Sender: TObject);
var
  i1 : integer;
  ret : integer;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    ret := MBScreenOverlay_Ellipse(Rect(Random(Screen.Width),Random(Screen.Height),   // Position
                                            Random(Screen.Width),Random(Screen.Height)),
                                       RGB(Random(255),Random(255),Random(255)));           // Color
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_LINEWIDTH, ret ,Random(3)+1, 0, 0);
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.TextButtonClick(Sender: TObject);
var
  i1 : integer;
  ret : integer;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    ret := MBScreenOverlay_Text(Point(Random(Screen.Width),Random(Screen.Height)), 'Test', 'Arial', Random(30)+8,LongInt((i1 mod 4) = 0), LongInt((i1 mod 3) = 0), RGB(Random(255),Random(255),Random(255)));
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.LineButtonClick(Sender: TObject);
var
  i1 : integer;
  ret : integer;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    ret := MBScreenOverlay_Line(Point(Random(Screen.Width),Random(Screen.Height)),   // Position
                              Point(Random(Screen.Width),Random(Screen.Height)),
                              RGB(Random(255),Random(255),Random(255)));           // Color
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_LINEWIDTH, ret ,Random(4)+1, 0, 0);
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.PolylineButtonClick(Sender: TObject);
var
  i1,i2 : integer;
  ret   : integer;
  TestPoints : array[1..5] of TPoint;
begin
  Randomize;
  for i1 := 1 to NumDemoElements do
  begin
    for i2 := 1 to 5 do
    begin
      TestPoints[i2].x := Random(Screen.Width);
      TestPoints[i2].y := Random(Screen.Height);
    end;
    ret := MBScreenOverlay_Polyline(@TestPoints,   // Position
                                  5,
                                  RGB(Random(255),Random(255),Random(255)));           // Color
    if (ret >= 0) then
    begin
      ObjectsListBox.Items.Add(IntToStr(ret));
      ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_LINEWIDTH, ret ,Random(4)+1, 0, 0);
      if (SmoothTransparencyCheckBox.Checked) then
        MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.BitmapButtonClick(Sender: TObject);
var
  ret   : integer;
begin
  Randomize;
  ret := MBScreenOverlay_BitmapByFile(Point(Random(Screen.Width),Random(Screen.Height)), // Position
                                          //Point(40,40), // Position
                                          //Point(32,32), // Position
                                          'ruler.bmp',               // Bitmap Name
                                          RGB(255,0,255));           // Transparent Color
  if (ret >= 0) then
  begin
    ObjectsListBox.Items.Add(IntToStr(ret));
    ObjectsListBox.State[ObjectsListBox.Items.Count-1] := cbChecked;
    MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETMOUSECURSOR, ret, -1, 0, 0);
    if (SmoothTransparencyCheckBox.Checked) then
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETTRANSPARENT, ret, random(60)+20, 0, 0);
  end;
end;

procedure TMBScreenOverlayDemoForm.ClearButtonClick(Sender: TObject);
begin
  MBScreenOverlay_Clear;
  ObjectsListBox.Clear;
  GridStart := 0;
  GridTrackBarChange(Sender);  
end;

procedure TMBScreenOverlayDemoForm.ObjectsListBoxDblClick(Sender: TObject);
var
  i1 : integer;
begin
  for i1 := ObjectsListBox.Items.Count-1 downto 0 do
  begin
    if ObjectsListBox.Selected[i1] then
    begin
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_DELETE, StrToInt(ObjectsListBox.Items[i1]),0,0,0);
      ObjectsListBox.Items.Delete(i1);
    end;
  end;
end;

procedure TMBScreenOverlayDemoForm.ObjectsListBoxClickCheck(Sender: TObject);
var
  i1 : integer;
begin
  for i1 := 0 to ObjectsListBox.Items.Count-1 do
    MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SHOW, StrToInt(ObjectsListBox.Items[i1]), LongInt(ObjectsListBox.Checked[i1]),0,0);
end;

procedure TMBScreenOverlayDemoForm.OverlayElementClick(var message : TMessage);
begin
  MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_CLICK  '+
                                 '[ID = '+IntToStr(message.WParam)+'] '+
                                 '[Position = ('+IntToStr(message.LParamLo)+'/'+IntToStr(message.LParamHi)+')');
end;

procedure TMBScreenOverlayDemoForm.OverlayElementDblClk(var message : TMessage);
begin
  MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_DBLCLK  '+
                                 '[ID = '+IntToStr(message.WParam)+'] '+
                                 '[Position = ('+IntToStr(message.LParamLo)+'/'+IntToStr(message.LParamHi)+')');
  MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_DELETE, message.WParam,0,0,0);
end;

procedure TMBScreenOverlayDemoForm.OverlayElementMouseDown(var message : TMessage);
begin
  MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_MOUSEDOWN  '+
                                 '[ID = '+IntToStr(message.WParam)+'] '+
                                 '[Position = ('+IntToStr(message.LParamLo)+'/'+IntToStr(message.LParamHi)+')');
end;

procedure TMBScreenOverlayDemoForm.OverlayElementMouseMove(var message : TMessage);
begin
  MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_MOUSEMOVE  '+
                                 '[ID = '+IntToStr(message.WParam)+'] '+
                                 '[Position = ('+IntToStr(message.LParamLo)+'/'+IntToStr(message.LParamHi)+')');
end;

procedure TMBScreenOverlayDemoForm.OverlayElementMouseUp(var message : TMessage);
begin
  MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_MOUSEUP  '+
                                 '[ID = '+IntToStr(message.WParam)+'] '+
                                 '[Position = ('+IntToStr(message.LParamLo)+'/'+IntToStr(message.LParamHi)+')');
end;

procedure TMBScreenOverlayDemoForm.OverlayElementStatusChange(var message : TMessage);
begin
  case message.LParam of
  STATUSCHANGED_SET_VISIBLE_TRUE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'SET_VISIBLE_TRUE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_SET_VISIBLE_FALSE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'SET_VISIBLE_FALSE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_AUTOSHOW:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'AUTOSHOW '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_AUTOHIDE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'AUTOHIDE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_SET_AUTOHIDE_TRUE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'SET_AUTOHIDE_TRUE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_SET_AUTOHIDE_FALSE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'SET_AUTOHIDE_FALSE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_INSERT:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'INSERT '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  STATUSCHANGED_DELETE:
    MessageListBox.Items.Insert(0, 'WM_OVERLAYELEMENT_STATUSCHANGED  '+
                                   'DELETE '+
                                   '[ID = '+IntToStr(message.WParam)+'] ');
  end;
end;

procedure TMBScreenOverlayDemoForm.GridCheckBoxClick(Sender: TObject);
begin
  GridTrackBar.Enabled := GridCheckBox.Checked;
  GridTrackBarChange(Sender)
end;

procedure TMBScreenOverlayDemoForm.GridTrackBarChange(Sender: TObject);
var
  i1,ret  :integer;
begin
  if (GridStart <> 0) then
    for i1 := GridStart to GridEnd do
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_DELETE, i1, 0,0,0);

  if GridCheckBox.Checked then
  begin
    for i1 := 1 to GridTrackBar.Position do
    begin
       ret := MBScreenOverlay_Line(Point(           0,trunc(i1 * Screen.Height / (GridTrackBar.Position+1))),   // Position
                                       Point(Screen.Width,trunc(i1 * Screen.Height / (GridTrackBar.Position+1))),
                                       RGB(Random(32),Random(32),Random(32)));           // Color
       if i1 = 1 then GridStart := ret;
       MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETAUTOHIDE, ret, 1, 0, 0);
       MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETZORDER, ret, 0, 0, 0);
    end;
    for i1 := 1 to GridTrackBar.Position do
    begin
      ret := MBScreenOverlay_Line(Point(trunc(i1 * Screen.Width / (GridTrackBar.Position+1)), 0),   // Position
                                      Point(trunc(i1 * Screen.Width / (GridTrackBar.Position+1)), screen.Height),
                                      RGB(Random(32),Random(32),Random(32)));           // Color
      if i1 = GridTrackBar.Position then GridEnd := ret;
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETAUTOHIDE, ret, 1, 0, 0);
      MBScreenOverlay_Operation(OVERLAYELEMENT_OPERATION_SETZORDER, ret, 0, 0, 0);
    end;
  end
end;

procedure TMBScreenOverlayDemoForm.ScriptButtonClick(Sender: TObject);
begin
  MBScreenOverlay_ScriptCommandFile('TestScriptCommandFile.txt');
  MBScreenOverlay_ScriptCommandFile('MB-ScreenOverlay.script');
end;

end.
