/*
 * Created by SharpDevelop.
 * User: Markus
 * Date: 13.08.2005
 * Time: 15:40
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using MBScreenOverlaySDK;

namespace MBScreenOverlayDemoCSharp
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button ScriptButton;
		private System.Windows.Forms.Button RectButton;
		private System.Windows.Forms.Button EllipseButton;
		private System.Windows.Forms.CheckBox GridCheckBox;
		private System.Windows.Forms.Button PolygonButton;
		private System.Windows.Forms.Button BitmapButton;
		private System.Windows.Forms.Button TextButton;
		private System.Windows.Forms.ListBox MessageListBox;
		private System.Windows.Forms.Button PointButton;
		private System.Windows.Forms.Button ClearObjectsButton;
		private System.Timers.Timer VisibleUpdatetimer;
		private System.Windows.Forms.Button LineButton;
		private System.Windows.Forms.TrackBar GridTrackBar;
		private System.Windows.Forms.CheckedListBox ObjectsListBox;
		
		private CMBScreenOverlaySDK MBScreenOverlaySDK;
		
		private int GridStart;
		private int GridEnd;
		
		public MainForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
		}
		
		[STAThread]
		public static void Main(string[] args)
		{
			Application.Run(new MainForm());
		}
		
		#region Windows Forms Designer generated code
		/// <summary>
		/// This method is required for Windows Forms designer support.
		/// Do not change the method contents inside the source code editor. The Forms designer might
		/// not be able to load this method if it was changed manually.
		/// </summary>
		private void InitializeComponent() {
			this.ObjectsListBox = new System.Windows.Forms.CheckedListBox();
			this.GridTrackBar = new System.Windows.Forms.TrackBar();
			this.LineButton = new System.Windows.Forms.Button();
			this.VisibleUpdatetimer = new System.Timers.Timer();
			this.ClearObjectsButton = new System.Windows.Forms.Button();
			this.PointButton = new System.Windows.Forms.Button();
			this.MessageListBox = new System.Windows.Forms.ListBox();
			this.TextButton = new System.Windows.Forms.Button();
			this.BitmapButton = new System.Windows.Forms.Button();
			this.PolygonButton = new System.Windows.Forms.Button();
			this.GridCheckBox = new System.Windows.Forms.CheckBox();
			this.EllipseButton = new System.Windows.Forms.Button();
			this.RectButton = new System.Windows.Forms.Button();
			this.ScriptButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.GridTrackBar)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.VisibleUpdatetimer)).BeginInit();
			this.SuspendLayout();
			// 
			// ObjectsListBox
			// 
			this.ObjectsListBox.Location = new System.Drawing.Point(280, 0);
			this.ObjectsListBox.Name = "ObjectsListBox";
			this.ObjectsListBox.Size = new System.Drawing.Size(320, 244);
			this.ObjectsListBox.TabIndex = 10;
			this.ObjectsListBox.MouseUp += new System.Windows.Forms.MouseEventHandler(this.ObjectsListBoxMouseUp);
			// 
			// GridTrackBar
			// 
			this.GridTrackBar.Enabled = false;
			this.GridTrackBar.Location = new System.Drawing.Point(9, 203);
			this.GridTrackBar.Minimum = 1;
			this.GridTrackBar.Name = "GridTrackBar";
			this.GridTrackBar.Size = new System.Drawing.Size(264, 45);
			this.GridTrackBar.TabIndex = 9;
			this.GridTrackBar.TabStop = false;
			this.GridTrackBar.Value = 1;
			this.GridTrackBar.Scroll += new System.EventHandler(this.GridTrackBarScroll);
			// 
			// LineButton
			// 
			this.LineButton.Location = new System.Drawing.Point(144, 40);
			this.LineButton.Name = "LineButton";
			this.LineButton.Size = new System.Drawing.Size(128, 24);
			this.LineButton.TabIndex = 6;
			this.LineButton.Text = "10 test lines";
			this.LineButton.Click += new System.EventHandler(this.LineButtonClick);
			// 
			// VisibleUpdatetimer
			// 
			this.VisibleUpdatetimer.SynchronizingObject = this;
			this.VisibleUpdatetimer.Elapsed += new System.Timers.ElapsedEventHandler(this.VisibleUpdatetimerElapsed);
			// 
			// ClearObjectsButton
			// 
			this.ClearObjectsButton.Location = new System.Drawing.Point(8, 152);
			this.ClearObjectsButton.Name = "ClearObjectsButton";
			this.ClearObjectsButton.Size = new System.Drawing.Size(128, 24);
			this.ClearObjectsButton.TabIndex = 4;
			this.ClearObjectsButton.Text = "clear object";
			this.ClearObjectsButton.Click += new System.EventHandler(this.ClearObjectsButtonClick);
			// 
			// PointButton
			// 
			this.PointButton.Location = new System.Drawing.Point(8, 8);
			this.PointButton.Name = "PointButton";
			this.PointButton.Size = new System.Drawing.Size(128, 24);
			this.PointButton.TabIndex = 0;
			this.PointButton.Text = "10 test point";
			this.PointButton.Click += new System.EventHandler(this.PointButtonClick);
			// 
			// MessageListBox
			// 
			this.MessageListBox.ItemHeight = 14;
			this.MessageListBox.Location = new System.Drawing.Point(0, 256);
			this.MessageListBox.Name = "MessageListBox";
			this.MessageListBox.Size = new System.Drawing.Size(600, 214);
			this.MessageListBox.TabIndex = 11;
			// 
			// TextButton
			// 
			this.TextButton.Location = new System.Drawing.Point(8, 40);
			this.TextButton.Name = "TextButton";
			this.TextButton.Size = new System.Drawing.Size(128, 24);
			this.TextButton.TabIndex = 1;
			this.TextButton.Text = "10 test texts";
			this.TextButton.Click += new System.EventHandler(this.TextButtonClick);
			// 
			// BitmapButton
			// 
			this.BitmapButton.Location = new System.Drawing.Point(144, 104);
			this.BitmapButton.Name = "BitmapButton";
			this.BitmapButton.Size = new System.Drawing.Size(128, 24);
			this.BitmapButton.TabIndex = 3;
			this.BitmapButton.Text = "test bitmap";
			this.BitmapButton.Click += new System.EventHandler(this.BitmapButtonClick);
			// 
			// PolygonButton
			// 
			this.PolygonButton.Location = new System.Drawing.Point(8, 72);
			this.PolygonButton.Name = "PolygonButton";
			this.PolygonButton.Size = new System.Drawing.Size(128, 24);
			this.PolygonButton.TabIndex = 2;
			this.PolygonButton.Text = "10 test polygons";
			this.PolygonButton.Click += new System.EventHandler(this.PolygonButtonClick);
			// 
			// GridCheckBox
			// 
			this.GridCheckBox.Location = new System.Drawing.Point(8, 184);
			this.GridCheckBox.Name = "GridCheckBox";
			this.GridCheckBox.Size = new System.Drawing.Size(120, 16);
			this.GridCheckBox.TabIndex = 8;
			this.GridCheckBox.Text = "screen grid";
			this.GridCheckBox.CheckedChanged += new System.EventHandler(this.GridCheckBoxCheckedChanged);
			// 
			// EllipseButton
			// 
			this.EllipseButton.Location = new System.Drawing.Point(144, 72);
			this.EllipseButton.Name = "EllipseButton";
			this.EllipseButton.Size = new System.Drawing.Size(128, 24);
			this.EllipseButton.TabIndex = 7;
			this.EllipseButton.Text = "10 test ellipses";
			this.EllipseButton.Click += new System.EventHandler(this.EllipseButtonClick);
			// 
			// RectButton
			// 
			this.RectButton.Location = new System.Drawing.Point(144, 8);
			this.RectButton.Name = "RectButton";
			this.RectButton.Size = new System.Drawing.Size(128, 24);
			this.RectButton.TabIndex = 5;
			this.RectButton.Text = "10 test rectangles";
			this.RectButton.Click += new System.EventHandler(this.RectButtonClick);
			// 
			// ScriptButton
			// 
			this.ScriptButton.Location = new System.Drawing.Point(9, 104);
			this.ScriptButton.Name = "ScriptButton";
			this.ScriptButton.Size = new System.Drawing.Size(128, 24);
			this.ScriptButton.TabIndex = 12;
			this.ScriptButton.Text = "test script";
			this.ScriptButton.Click += new System.EventHandler(this.ScriptButtonClick);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(600, 470);
			this.Controls.Add(this.ScriptButton);
			this.Controls.Add(this.MessageListBox);
			this.Controls.Add(this.ObjectsListBox);
			this.Controls.Add(this.GridTrackBar);
			this.Controls.Add(this.GridCheckBox);
			this.Controls.Add(this.EllipseButton);
			this.Controls.Add(this.LineButton);
			this.Controls.Add(this.RectButton);
			this.Controls.Add(this.ClearObjectsButton);
			this.Controls.Add(this.BitmapButton);
			this.Controls.Add(this.PolygonButton);
			this.Controls.Add(this.TextButton);
			this.Controls.Add(this.PointButton);
			this.Font = new System.Drawing.Font("Arial", 11F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.World);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.Name = "MainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "MB-ScreenOverlay SDK-Demo C#";
			this.Load += new System.EventHandler(this.MBScreenOverlayDemoFormLoad);
			((System.ComponentModel.ISupportInitialize)(this.GridTrackBar)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.VisibleUpdatetimer)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion
		
		protected override void WndProc(ref Message m)
		{
            switch (m.Msg)
            {
            	case (int)WM_OVERLAYELEMENT.CLICK:
            		MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_CLICK  "+
            		                            "[ID = "+((int)m.WParam).ToString()+"] "+
            		                            "[Position = ("+(m.LParam.ToInt32() & 0xFFFF)+"/"+(m.LParam.ToInt32() >> 16)+")");
            	break;
            	case (int)WM_OVERLAYELEMENT.DBLCLK:
					MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_DBLCLK  "+
            		                            "[ID = "+(int)m.WParam+"] "+
												"[Position = ("+(m.LParam.ToInt32() & 0xFFFF)+"/"+(m.LParam.ToInt32() >> 16)+")");
            		MBScreenOverlaySDK.DeleteItem((int)m.WParam);
            	break;
            	
            	case (int)WM_OVERLAYELEMENT.MOUSEDOWN:
					MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_MOUSEDOWN  "+
            		                            "[ID = "+(int)m.WParam+"] "+
												"[Position = ("+(m.LParam.ToInt32() & 0xFFFF)+"/"+(m.LParam.ToInt32() >> 16)+")");
            	break;
            	case (int)WM_OVERLAYELEMENT.MOUSEMOVE:
					MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_MOUSEMOVE  "+
            		                            "[ID = "+(int)m.WParam+"] "+
												"[Position = ("+(m.LParam.ToInt32() & 0xFFFF)+"/"+(m.LParam.ToInt32() >> 16)+")");
            	break;
            	case (int)WM_OVERLAYELEMENT.MOUSEUP:
					MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_MOUSEUP  "+
            		                            "[ID = "+(int)m.WParam+"] "+
												"[Position = ("+(m.LParam.ToInt32() & 0xFFFF)+"/"+(m.LParam.ToInt32() >> 16)+")");
            	break;    
            	case (int)WM_OVERLAYELEMENT.STATUSCHANGED:
            	{
            		switch ((int)m.LParam)
            		{
            			case (int)OVERLAYSDK_STATUSCHANGED.SET_VISIBLE_TRUE:
					    	MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
					        	                           "SET_VISIBLE_TRUE "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.SET_VISIBLE_FALSE:
						    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
						                                   "SET_VISIBLE_FALSE "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.AUTOSHOW:
						    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
						                                   "AUTOSHOW "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case(int)OVERLAYSDK_STATUSCHANGED.AUTOHIDE:
						    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
						                                   "AUTOHIDE "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.SET_AUTOHIDE_TRUE:
						    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
						                                   "SET_AUTOHIDE_TRUE "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.SET_AUTOHIDE_FALSE:
						    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
						                                   "SET_AUTOHIDE_FALSE "+
					            	                       "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.INSERT:
					    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
					                                   "INSERT "+
					            	                   "[ID = "+(int)m.WParam+"] ");
            			break;
					  	case (int)OVERLAYSDK_STATUSCHANGED.DELETE:
					    MessageListBox.Items.Insert(0, "WM_OVERLAYELEMENT_STATUSCHANGED  "+
					                                   "DELETE "+
					          	                       "[ID = "+(int)m.WParam+"] ");
            			break;
            		}
            	}
            	break;                              
            }
            base.WndProc(ref m);        
		}
		
		void MBScreenOverlayDemoFormLoad(object sender, System.EventArgs e)
		{
			ObjectsListBox.Items.Clear();
			MessageListBox.Items.Clear();
			MBScreenOverlaySDK = new CMBScreenOverlaySDK();
			MBScreenOverlaySDK.Clear();
			MBScreenOverlaySDK.SetCallBackWindowHandle(Handle.ToInt32());
			
			GridStart = 0;
			GridEnd = 0;			
		}
		
		void PointButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Random r = new Random();
			for (i1=0;i1 < 10; i1++)
			{				
			    ret = MBScreenOverlaySDK.Point(new Point(r.Next(0,SystemInformation.WorkingArea.Width),r.Next(0,SystemInformation.WorkingArea.Height)),   // Position
                			                       r.Next(0,3),                                           // Style
                            			           Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString()); 
    				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);      			
    			}
			}
		}
		
		void RectButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Random r = new Random(); 
			for (i1=0;i1 < 10; i1++)
			{				
				ret = MBScreenOverlaySDK.Rectangle(new Rectangle(r.Next(0,SystemInformation.WorkingArea.Width-400),r.Next(0,SystemInformation.WorkingArea.Height-400),r.Next(0,400 ),r.Next(0,400)),   // Position
                              			               Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString());
    				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);      			    				
    			}
			}			
		}
		
		void TextButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Random r = new Random();
			for (i1=0;i1 < 10; i1++)
			{				
				ret = MBScreenOverlaySDK.Text(new Point(r.Next(0,SystemInformation.WorkingArea.Width),r.Next(0,SystemInformation.WorkingArea.Height)),   // Position
                			                      "Hallo", "Arial", 
                			                      r.Next(10,30 ),false,false,
                              			          Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString());    				
      				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);  
    			}
			}						
		}
		
		void LineButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Random r = new Random(); 
			for (i1=0;i1 < 10; i1++)
			{				
			    ret = MBScreenOverlaySDK.Line(new Point(r.Next(0,SystemInformation.WorkingArea.Width),r.Next(0,SystemInformation.WorkingArea.Height)),   // Position
				                                  new Point(r.Next(0,SystemInformation.WorkingArea.Width),r.Next(0,SystemInformation.WorkingArea.Height)),   // Position
                            			          Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString()); 
      				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);  
      				MBScreenOverlaySDK.LineWidth(ret, r.Next(1,4));
    			}
			}			
		}
						
		void PolygonButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Point[] Points = new Point[3];;
			
			Random r = new Random(); 
			for (i1=0;i1 < 10; i1++)
			{			
				for (int i2 = 0; i2 < 3;i2++)
				{
					Points[i2].X = r.Next(0,SystemInformation.WorkingArea.Width);
					Points[i2].Y = r.Next(0,SystemInformation.WorkingArea.Height);
				}
				ret = MBScreenOverlaySDK.Polyline(Points,3,
                              			              Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString());    				
      				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true); 
      				MBScreenOverlaySDK.LineWidth(ret, r.Next(1,4));
    			}
			}						
		}
		
		void EllipseButtonClick(object sender, System.EventArgs e)
		{
			int i1;
			int ret;
			Random r = new Random(); 
			for (i1=0;i1 < 10; i1++)
			{				
				ret = MBScreenOverlaySDK.Ellipse(new Rectangle(r.Next(0,SystemInformation.WorkingArea.Width-400),r.Next(0,SystemInformation.WorkingArea.Height-400),r.Next(0,400 ),r.Next(0,400)),   // Position
                              			             Color.FromArgb(100, r.Next(0,255),r.Next(0,255),r.Next(0,255)));           // Color
    			if (ret >= 0)
    			{
    				ObjectsListBox.Items.Add(ret.ToString());    				
      				ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);  
    			}
			}			
		}
		
		void BitmapButtonClick(object sender, System.EventArgs e)
		{
			int ret;
			Random r = new Random();
			
			ret = MBScreenOverlaySDK.BitmapByFile(new Point(r.Next(0,SystemInformation.WorkingArea.Width),r.Next(0,SystemInformation.WorkingArea.Height)),   // Position
               			                        "ruler.bmp",                                           // Style
                           			            Color.FromArgb(0, 255,0,255));           // Color
   			if (ret >= 0)
   			{
   				ObjectsListBox.Items.Add(ret.ToString());    				
      			ObjectsListBox.SetItemChecked(ObjectsListBox.Items.Count-1, true);  
      			MBScreenOverlaySDK.SetMouseCursor(ret, -1);
   			}			
		}		
		void ClearObjectsButtonClick(object sender, System.EventArgs e)
		{
			MBScreenOverlaySDK.Clear();
			ObjectsListBox.Items.Clear();
		}
		
		void GridTrackBarScroll(object sender, System.EventArgs e)
		{	
			int i1 = 0;
			int ret = 0;
			
   			if (GridStart != 0) 
   				for (i1 = GridStart; i1 <= GridEnd ; i1++)
       				MBScreenOverlaySDK.DeleteItem(i1);			
			
			if (GridCheckBox.Checked)
			{							
				for (i1 = 1; i1 <= GridTrackBar.Value; i1++)
				{
					ret = MBScreenOverlaySDK.Line(new Point(i1 * SystemInformation.WorkingArea.Width / (GridTrackBar.Value+1),0),   // Position
					                                  new Point(i1 * SystemInformation.WorkingArea.Width / (GridTrackBar.Value+1),SystemInformation.WorkingArea.Height),   // Position
	                            			          Color.FromArgb(100,32,32,32));           // Color
					if (i1 == 1) GridStart = ret;
					MBScreenOverlaySDK.AutoHideItem(ret, true);
					MBScreenOverlaySDK.ChangeZOrder(ret, 0);					
				}
				
				for (i1 = 1; i1 <= GridTrackBar.Value; i1++)
				{
					ret = MBScreenOverlaySDK.Line(new Point(0, i1 * SystemInformation.WorkingArea.Height / (GridTrackBar.Value+1)),   // Position
					                                  new Point(SystemInformation.WorkingArea.Width, i1 * SystemInformation.WorkingArea.Height / (GridTrackBar.Value+1)),   // Position
	                            			          Color.FromArgb(100,32,32,32));           // Color
					if (i1 == GridTrackBar.Value) GridEnd = ret;
					MBScreenOverlaySDK.AutoHideItem(ret, true);
					MBScreenOverlaySDK.ChangeZOrder(ret, 0);
				}			
			}
		}				
		void GridCheckBoxCheckedChanged(object sender, System.EventArgs e)
		{
			GridTrackBar.Enabled = GridCheckBox.Checked;
			GridTrackBarScroll(sender, e);			
		}		
		
		void ObjectsListBoxItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			for (int i1=0; i1 < ObjectsListBox.Items.Count-1; i1++)
			{												
				MBScreenOverlaySDK.VisibleItem( System.Convert.ToInt32(ObjectsListBox.Items[i1]), ObjectsListBox.GetItemChecked(i1));
				MessageListBox.Items.Insert(0,  System.Convert.ToInt32(ObjectsListBox.Items[i1])+" "+ObjectsListBox.GetItemChecked(i1));
			}			
		}
		
		void ObjectsListBoxMouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			VisibleUpdatetimer.Enabled = true;
		}
		
		void ObjectsListBoxSelectedValueChanged(object sender, System.EventArgs e)
		{
						
		}
		
		void VisibleUpdatetimerElapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			VisibleUpdatetimer.Enabled = false;
			for (int i1=0; i1 < ObjectsListBox.Items.Count-1; i1++)
			{												
				MBScreenOverlaySDK.VisibleItem( System.Convert.ToInt32(ObjectsListBox.Items[i1]), ObjectsListBox.GetItemChecked(i1));
				MessageListBox.Items.Insert(0,  System.Convert.ToInt32(ObjectsListBox.Items[i1])+" "+ObjectsListBox.GetItemChecked(i1));
			}									
		}
		
		void ScriptButtonClick(object sender, System.EventArgs e)
		{
			MBScreenOverlaySDK.ScriptCommandFile("TestScriptCommandFile.txt");
		}
		
	}
}
