//////////////////////////////////////////////////////////////////////////////////////
//                                                                                  //
//  bmp2gif is based on the open source GIFIMAGE library of Anders Melander and     //
//  is therefore open source itself                                                 //
//                                                                                  //
//  To compile the file with Delphi 5.0, please download the GIFIMAGE component     //
//  from http://www.melander.dk/delphi/gifimage                                     //
//                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////

program bmp2gif;
{$APPTYPE CONSOLE}
uses
  sysutils,
  windows,
  graphics,
  clipbrd,
  GIFImage in 'GIFImage.pas';

var
  GIFbmp : TGIFImage;
  bmp    : TBitmap;

  MyFormat : Word;

  AData    : Cardinal;
  APalette : HPalette;


begin
  if (paramcount=2) then
  begin
    if Fileexists(paramstr(1)) then
    begin
      try
        bmp := TBitmap.Create;
        bmp.LoadFromFile(paramstr(1));
        bmp.SaveToClipboardFormat(MyFormat,AData,APalette);
        ClipBoard.SetAsHandle(MyFormat,AData);
        GIFbmp := TGIFImage.Create;
        GIFbmp.Palette := bmp.Palette;
        GIFbmp.LoadFromClipboardFormat(MyFormat,AData,APalette);
        GIFbmp.SaveToFile(paramstr(2));
        GIFbmp.Destroy;
        bmp.Destroy;
      except
        writeln('error when converting bitmap');
      end;
    end
    else
      writeln('Bitmap '+paramstr(1)+' does not exist.');
  end
  else
    writeln('call: bmp2gif <bitmap>.bmp <bitmap>.gif');
end.
