library Ffdemo;

uses wintypes,winprocs,dialogs;

type
  screen_coordinates_function = function (r : real) : longint;

var
  xb,yb : screen_coordinates_function;

function dummy_xb(r : real) : longint; begin dummy_xb := trunc(r); end;
function dummy_yb(r : real) : longint; begin dummy_yb := trunc(r); end;

function DANCE_ModidyString  : string; export;
begin
  DANCE_ModidyString := 'Color 1/Color 2/Color 3/Color 4/';
end;

procedure DANCE_RemoteProcedure(x,y : tfarproc); export;
begin try @xb := x; @yb := y; except xb := dummy_xb; yb := dummy_yb; end; end;

procedure DANCE_MyShowFuss(surface : hdc; pair,dancer,foot  : byte; x,y,w : word; styleofstep : byte); export;
var
  pen,oldpen    : hpen;
  brush,oldbrush : hbrush;
begin
  try
    case styleofstep of
      0 : begin
            pen := createpen(0,3,rgb(255,0,0));
            brush := createsolidbrush(rgb(255,0,0));
          end;
      1 : begin
            pen := createpen(0,3,rgb(0,255,0));
            brush := createsolidbrush(rgb(0,255,0));
          end;
      2 : begin
            pen := createpen(0,3,rgb(0,0,255));
            brush := createsolidbrush(rgb(0,0,255));
          end;
      3 : begin
            pen := createpen(0,3,rgb(255,0,255));
            brush := createsolidbrush(rgb(255,0,255));
          end;
    100 : begin
            pen := createpen(0,2,rgb(255,255,255));
            brush := createsolidbrush(rgb(255,255,255));
          end;
    101 : begin
            pen := createpen(0,1,rgb(200,200,200));
            brush := createsolidbrush(rgb(200,200,200));
          end;
    102 : begin
            pen := createpen(0,1,rgb(230,230,230));
            brush := createsolidbrush(rgb(230,230,230));
          end;
    end;
    oldpen := selectobject(surface,pen);
    oldbrush := selectobject(surface,brush);
    ellipse(surface,xb(x-10),yb(y-10),xb(x+10),yb(y+10));
    moveto(surface,xb(x),yb(y));
    lineto(surface,xb(trunc(x-20.0*sin(w*pi/180.0))),yb(trunc(y)+20.0*cos(w*pi/180.0)));
    selectobject(surface,oldpen);
    deleteobject(pen);
    selectobject(surface,oldbrush);
    deleteobject(brush);
  except
    selectobject(surface,oldpen);
    deleteobject(pen);
    selectobject(surface,oldbrush);
    deleteobject(brush);
  end;
end;

exports
  DANCE_MyShowFuss          index 1,
  DANCE_RemoteProcedure     index 2,
  DANCE_ModidyString        index 3;

begin
  xb := dummy_xb; yb := dummy_yb;
end.

